;
;Lecture sequentielle de fichier
;
;CALL &9000,"fichier" : ouvre fichier
;CALL &9003,dest : fixe adr destination
;CALL &9006,long : ecrit <long> octets a partir de dest
;CALL &9009 : ferme fichier
;CALL &900C,"fichier",adr,longueur : sauve fichier binaire
;&900F : compteur d'octets (16 bit)
;
CAS_IN_OPEN     equ #bc77
CAS_IN_CLOSE    equ #bc7a
CAS_IN_CHAR     equ #bc80

CAS_OUT_OPEN    equ #bc8c
CAS_OUT_CLOSE   equ #bc8f
CAS_OUT_DIRECT  equ #bc98

         ORG  #9000
         limit #90E0
;
TAMPON   EQU  #9100
;
         JP   IN_OPEN           ;+0
         JP   IN_FIXEDEST       ;+3
         JP   IN_READ           ;+6
         JP   CAS_IN_CLOSE      ;+9
         JP   OUT_SAVE          ;+12
COMPTEUR DEFW 0 ; nombre d'octets lus   ;+15
IN_DEST  DEFW #C000
;
;
IN_OPEN
         DEC  A
         RET  NZ
         EX   DE,HL
         LD   B,(HL)
         INC  HL
         LD   E,(HL)
         INC  HL
         LD   D,(HL)
         EX   DE,HL
;
         LD   DE,TAMPON
         CALL CAS_IN_OPEN
         LD   HL,0
         LD   (COMPTEUR),HL
         RET
;
IN_FIXEDEST
         DEC  A
         RET  NZ
         LD   (IN_DEST),DE
         RET
;
IN_READ
         LD   HL,(COMPTEUR)
         ADD  HL,DE
         LD   (COMPTEUR),HL
         LD   HL,(IN_DEST)
LOOP
         PUSH DE
         PUSH HL
         CALL CAS_IN_CHAR
         POP  HL
         LD   (HL),A
         INC  HL
         POP  DE
         DEC  DE
         LD   A,D
         OR   E
         JR   NZ,LOOP
;
         LD   (IN_DEST),HL
         RET
;
;

;CALL OUT_SAVE,"fichier",adresse,longueur
OUT_SAVE
        cp 3 ; 3 parametres
        ret nz
;
        ld l,(ix+2)
        ld h,(ix+3)
        push hl
        ld l,(ix+4)
        ld h,(ix+5)
        ld b,(hl) ; b = longueur du nom de fichier
        inc hl
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a ; hl = adresse du nom de fichier
        push de
        ld de,#C000 ; le buffer ne sera pas utilise
        call CAS_OUT_OPEN
        pop de
        pop hl
        ret nc   ; error opening the file
;
        ld a,2  ; type binaire
        ; hl = adresse
        ; de = longueur
        ld bc,0 ; adresse d'execution
        call CAS_OUT_DIRECT
        jp CAS_OUT_CLOSE
