;Adapted from PLAY-AY.SCE v0.5 by OVerLanders 24/5/2000
;for Soundtracker DMA v2.0 by Zik/Futurs' 2021
;
;; Changes:
;;  - Only supports #100 buffers
;;  - Does not handle music loop
;;  - PLAYREG code for Soundtracker DMA v2.0
;;  - Decompress 15 streams to handle the 14 AY registers, SID and sample
;

; SPACE key to quit
; DOWN key for fast forward

DECRUBUF equ #C000	;address must be multiple of #100
			;NBRREG decompression buffers, #100 each

	org #2800
;
	di
	ld bc,#bc09
	out (c),c
	ld bc,#bd02
	out (c),c
	;
	ld bc,#bc04
	out (c),c
	ld bc,#bd00+103
	out (c),c

	ld      bc,#7f10
	out     (c),c
	ld      a,64+20 ; black raster
	out     (c),a
;
	ld      hl,(#38)
	ld      (INTER+1),hl
	ld      hl,#c9fb
	ld      (#38),hl
	exx
	ex      af,af'
	push    af
	push    bc
	push    de
	push    hl
	ei
	call    ENTRY_INITS
;
;
MAIN:	ld      b,#f5
SYNC_1:	in      a,(c)
	rra
	jr      nc,SYNC_1
;
	halt
	halt

	ld b,31*8-2 ; wait 31 lines + 1 NOP - following raster time
WAITL:	adc hl,hl	; 4 NOP
	djnz WAITL	; 4 or 3 NOP
	inc hl		; 2 NOP

FASTFOWA:
	ld      bc,#7f10
	out     (c),c
	ld      a,64+22 ; green raster
	out     (c),a
	;
	call    PLAYREG
	;
	ld      bc,#7f10
	out     (c),c
	ld      a,64+21 ; bright blue raster
	out     (c),a
	;
	call    GETREG
	;
	ld      bc,#7f10
	out     (c),c
	ld      a,64+20 ; black raster
	out     (c),a

	halt
	ld      bc,#7f00+64+18 ; bright green raster
	out     (c),c
	;
MESURE: ld      hl,0
	dec     hl
	ld      (MESURE+1),hl
	ld      a,h
	or      l ; Z is set if end of music is reached
	call    z,ENTRY_INITS_AT_LOOP ; reached end of music; can restart after a call to INITS_AT_LOOP (shorter than INITS)
	halt
	ld      bc,#7f00+64+20 ; black raster
	out     (c),c
;
	ld      a,#40 ; DOWN key (fast forward)
	call    TST_KEY
	and     4
	jr      z,FASTFOWA
;
	ld      a,#45 ; SPACE key (quit)
	call    TST_KEY
	and     128
	jp      nz,MAIN
;
FIN:
	call    ENTRY_STOPMUS
	di
INTER:  ld      hl,0
	ld      (#38),hl
	pop     hl
	pop     de
	pop     bc
	pop     af
	ex      af,af'
	exx
	ei

	ld bc,#bc09
	out (c),c
	ld bc,#bd07
	out (c),c
	;
	ld bc,#bc04
	out (c),c
	ld bc,#bd00+38
	out (c),c
;	jp      #bca7
	ret

;
TST_KEY:
	di
	ld      bc,#f40e
	out     (c),c
	ld      bc,#f6c0
	out     (c),c
	out     (c),0 ; db #ed,#71
	ld      bc,#f792
	out     (c),c
	ld      b,#f6
	out     (c),a
	ld      a,#f4
	in      a,(0)
	out     (c),0 ; db #ed,#71
	ld      bc,#f782
	out     (c),c
	ei
	ret
;
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DUREE    equ YMLZ	;Music duration is first 16-bit value of data header (number of frames)
NBRREG   equ 15		;Number of streams


ENTRY_INITS:
	call delock_asic
	call PageAsicOn
	xor a
	ld (PPR0),a ; Pause unit DMA0 (Sid)
	ld (PPR2),a ; Pause unit DMA2 (Samples)
	call PageAsicOff
;
	call    RAZ_PSG
	call    POKECODE
ENTRY_INITS_AT_LOOP
;READHEAD:
;Analyze header
	ld      hl,(DUREE)
	ld      (MESURE+1),hl
	call    RAZVAR
;Need to prepare some data in advance
	ld      b,NBRREG
AMORCE:	push    bc
	call    GETREG
	pop     bc
	djnz    AMORCE
	ret
;
;

;;PLAYREG routine updates all registers systematically except register 13
RAZ_PSG:
	xor a
	ld c,13
	call Send2PSG
	ret

ENTRY_STOPMUS
	call PageAsicOn
	ld a,(DCSR)
	and %11111000 ; Note: should not stop DMA1 depending on your application!
	ld (DCSR),a ; stop AY-Lists
	call PageAsicOff
	ld a,#3f
	ld c,7
	call Send2PSG
	xor a
	ld c,8
	call Send2PSG
	ld c,9
	call Send2PSG
	ld c,10
	jp Send2PSG
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;DMA registers
SAR0	equ #6C00	;; SAR0: channel 0 AY-list address register
PPR0	equ #6C02	;; PPR0: channel 0 pause unit register
SAR1	equ #6C04	;; SAR1: channel 1 AY-list address register
PPR1	equ #6C06	;; PPR1: channel 1 pause unit register
SAR2	equ #6C08	;; SAR2: channel 2 AY-list address register
PPR2	equ #6C0A	;; PPR2: channel 2 pause unit register
DCSR	equ #6C0F	;; DMA Control and Status Register
;
PLAYREG:
	; Wait to meet wanted position to HBL for DMA register update
	ld b,52/4-1
	djnz $
	add hl,hl ; 3 NOPs

;; Player starts here
; Decode SID and sample play data
	ld hl,(PLAYPLAG+1)
	ld de,0 ; D=DMAmodSID ; E=DMAmodSample ; action by default, may need to stop SID and sample
;
	ld a,h
	add a,14
	ld h,a
	ld b,(hl) ; stream 14 (SIDPeriod LSB)
	sub a,7
	ld h,a
	ld a,(hl) ; stream 7
	; write SID period to AY-List even if it did not change (faster)
	rlca ; write SIDPeriod MSB bit to Carry
	rr b
	ld a,b
	ld (SidList+4),a
	adc a,255 ; rounding -1
	ld (SidList+8),a
;
	inc h
	ld a,(hl) ; stream 8
	bit 7,a
	jr nz,VolASample
	bit 6,a
	jr z,VolANormal
VolASID	ld c,a
	and #1f ; carry cleared ; optim: not mandatory
	ld (SidList+2),a ; Sid vol1
	bit 5,c
	jr nz,SIDMidA
	xor a ; carry cleared
SIDMidA	rra
	ld (SidList+6),a ; Sid vol2
	ld a,8 ; reg8
	ld (SidList+3),a ; Sid channel
	ld (SidList+7),a ; Sid channel
	ld d,a ; DMAmodSID, non-null value indicates SID AY-list must be started
	ld a,e
VolASample
	ld e,a ; DMAmodSample, sample AY-list must keep running (#80) or be started (>#80)
VolANormal
	inc h
	ld a,(hl) ; stream 9
	bit 7,a
	jr nz,VolBSample
	bit 6,a
	jr z,VolBNormal
VolBSID	ld c,a
	and #1f ; carry cleared ; optim: not mandatory
	ld (SidList+2),a ; Sid vol1
	bit 5,c
	jr nz,SIDMidB
	xor a ; carry cleared
SIDMidB	rra
	ld (SidList+6),a ; Sid vol2
	ld a,9 ; reg9
	ld (SidList+3),a ; Sid channel
	ld (SidList+7),a ; Sid channel
	ld d,a ; DMAmodSID, non-null value indicates SID AY-list must be started
	ld a,e
VolBSample
	ld e,a ; DMAmodSample, sample AY-list must keep running (#80) or be started (>#80)
VolBNormal
	inc h
	ld a,(hl) ; stream 10
	bit 7,a
	jr nz,VolCSample
	bit 6,a
	jr z,VolCNormal
VolCSID	ld c,a
	and #1f ; carry cleared ; optim: not mandatory
	ld (SidList+2),a ; Sid vol1
	bit 5,c
	jr nz,SIDMidC
	xor a ; carry cleared
SIDMidC	rra
	ld (SidList+6),a ; Sid vol2
	ld a,10 ; reg10
	ld (SidList+3),a ; Sid channel
	ld (SidList+7),a ; Sid channel
	ld d,a ; DMAmodSID, non-null value indicates SID AY-list must be started
	ld a,e
VolCSample
	ld e,a ; DMAmodSample, sample AY-list must keep running (#80) or be started (>#80)
VolCNormal

;; Program sound DMAs (Sid and sample)
; - Do only one read-modify-write of DCSR
; - Minimize delay between DCSR read and write
; - Stable delay between SAR and DCSR updates

	call PageAsicOn ; 15 NOPs
	ld bc,%00000011*256+0 ; mask DMA2 state (samples); ack no interrupt
	ld a,e ; DMAmodSample = 0 (stop sample) or 128 (nothing to do) or >128 (start sample)
	or a
	jr z,SampleAYLOff
	ld b,%00000111 ; no DMA mask; ack no interrupt
	add a,a
	jr z,SampleAYLRunning ; sample was already running (got #80)
	adc hl,hl ; HACK, burn 4 NOPs to meet DMA timings (register programming vs internal processing)
	ld hl,TabSmpAdr-2 ; no sample 0
	add a,l
	ld l,a
	jr nc,addnocarry
	inc h
AddNoCarry
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a ; HL=address to write to SAR2
	ld c,4
	ld (SAR2),hl ; use DMA2 for samples
SampleAYLOff
SampleAYLRunning

; To avoid conflicts between DMA register update and DMA internal processing,
; accesses to ASIC DCSR register must avoid DMA processing zone that starts
; with HBL beginning.
; Without this precaution, unwanted behaviour may occur (sample not started, etc.).
; AY-lists have STOP instruction doubled as a precaution if you face a race condition.
;
; Do not expect an emulator to reproduce accurate behaviour on this point.

; If application uses DMA1, maximum DMA processing time is:
; 1 + 3 (fetch) + (8 + 8 + 2) (two LOAD and one other DMA instruction)
; => better access DMA DCSR register while CO = 4 to 45 (with default CRTC configuration)

; Up to here, timing depends on use case as follows:
;  - 3 "normal" sounds: ref (=0)
;  - 2 normal & 1 sample start: -3+26+4 = +27 NOPs
;  - 2 normal & 1 sample continue: -3+5 = +2 NOPs
;  - 2 normal & 1 SID: +29 NOPs (-3 possible by removing 'ld c,a' and 'and #1f')

; After this point, DCSR read (load instruction beginning) is at T (without SID) or T+1 NOPs (with SID)
; Time between DCSR read and write DCSR is 4 NOPs without SID, 9 or 13 NOPs with SID

;DCSR timing (ref):
; RD	WR
; 0	4	ok	norm
; 2	6	ok	smp cont
; 30	39/43	ok	sid
; 32	41/45	ok	sid + smp cont
; 27	31	ok	smp start
; 57	02/06	NOK	sid + smp start

;DCSR timing: +38
; RD	WR
; 38	42	ok	norm
; 40	44	ok	smp cont
; 04	13/17	ok	sid
; 06	15/19	ok	sid + smp cont
; 01	05	ok	smp start
; 31	40/44	ok	sid + smp start

	ld hl,SidList
	ld a,d ; DMAmodSID = 0 (stop SID) or non-null (start SID)
	ld de,DCSR
	or a
	jr nz,SidAYLOn
	dec b ; clear bit0 (DMA0 for Sid)
	ld a,(de) ; Read DCSR
	and b ; mask bit0 (DMA0)
	or c
	ld (de),a ; Write DCSR ; stop Sid & eventually start sample
	jr SidAYLexit
SidAYLOn
	inc c ; set bit0 (DMA0 for Sid)
	ld a,(de) ; Read DCSR
	bit 0,a
	jr nz,SidAYLRunning ; if Sid DMA is running, do not write SAR (would cause an audio glitch)
	ld (SAR0),hl ; start Sid ay-list from beginning
SidAYLRunning
	and b
	or c
	ld (de),a ; Write DCSR ; keep or start Sid & eventually start sample
SidAYLexit
	call PageAsicOff

PLAYPLAG:
	ld hl,DECRUBUF ; address LSB is self-modified (poke)
	ld a,l
	inc a
	ld (PLAYPLAG+1),a

;; Send all values to PSG (some conditions apply to volume registers)
; Note: Kit-AY routine is more optimized and only sends updated values
	ld a,(hl)
	ld c,0 ; channel A, period LSB
	call Send2PSG
	inc h
	ld a,(hl)
	ld c,1 ; channel A, period MSB
	call Send2PSG
	inc h
	ld a,(hl)
	ld c,2 ; channel B, period LSB
	call Send2PSG
	inc h
	ld a,(hl)
	ld c,3 ; channel B, period MSB
	call Send2PSG
	inc h
	ld a,(hl)
	ld c,4 ; channel C, period LSB
	call Send2PSG
	inc h
	ld a,(hl)
	ld c,5 ; channel C, period MSB
	call Send2PSG
;
	inc h
	ld a,(hl)
	ld c,6 ; noise
	call Send2PSG
;
	inc h
	ld a,(hl)
	and #3f ; may not be mandatory
	ld c,7 ; mixer
	call Send2PSG
;
; Update volume registers after having stopped sample and SID
; to ensure volume set for this frame is correct (volume from
; note, not from sample or SID played previously)
	ld d,%00100000 ; bit 7 for sample ; bit 6 and 5 for SID
	inc h
	ld a,(hl)
	cp d
	ld c,8 ; Channel A volume
	call c,Send2PSG
	inc h
	ld a,(hl)
	cp d
	ld c,9 ; Channel B volume
	call c,Send2PSG
	inc h
	ld a,(hl)
	cp d
	ld c,10 ; Channel C volume
	call c,Send2PSG
;
	inc h
	ld a,(hl)
	ld c,11 ; hard-env period LSB
	call Send2PSG
	inc h
	ld a,(hl)
	ld c,12 ; hard-env period MSB
	call Send2PSG
	inc h
	ld a,(hl)
	inc a
	ret z ; 255 => no retrig and no env shape change
	dec a
	ld c,13 ; hard-env shape
	jp Send2PSG

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
;
GETREG:
	di		; inutile dans le cas particulier de cet exemple
	ld      (SAVETMP+1),sp
	ld      a,NBRREG-1	; Necessaire pour V1 a V13
				; mais pas pour VMESURE/V0
	ld      iy,GET_RET
GETWITCH:
	jp      V0	;Quelle routine ?
GET_RET:
SAVETMP:
	ld      sp,0
	ei		; inutile dans le cas particulier de cet exemple
	ld      hl,(GETWITCH+1)
	dec     hl
	ld      d,(hl)	; Recupere adresse
	dec     hl
	ld      e,(hl)
	ld      (GETWITCH+1),de
	ret
;
;
	dw      V1	; Adresse prochaine routine
VMESURE:
V0:	ld      sp,REGS	; !!! PLACER le LD SP apres le label !!!
	jp      DECOMP0	;ATTENTION ! L'ecart doit rester

	dw      V2
V1:	ld      sp,REGS+10
	jp      DECOMP0	;constant pour les modifs d'ATTRIBU (plus nécessaire)

	dw      V3
V2:	ld      sp,REGS+20
	jp      DECOMP0

	dw      V4
V3:	ld      sp,REGS+30
	jp      DECOMP0

	dw      V5
V4:	ld      sp,REGS+40
	jp      DECOMP0

	dw      V6
V5:	ld      sp,REGS+50
	jp      DECOMP0

	dw      V7
V6:	ld      sp,REGS+60
	jp      DECOMP0

	dw      V8
V7:	ld      sp,REGS+70
	jp      DECOMP0

	dw      V9
V8:	ld      sp,REGS+80
	jp      DECOMP0

	dw      V10
V9:	ld      sp,REGS+90
	jp      DECOMP0

	dw      V11
V10:	ld      sp,REGS+100
	jp      DECOMP0

	dw      V12
V11:	ld      sp,REGS+110
	jp      DECOMP0

	dw      V13
V12:	ld      sp,REGS+120
	jp      DECOMP0

	dw      V14
V13:	ld      sp,REGS+130
	jp      DECOMP0

	dw      VMESURE     ; !!! BOUCLE EN CONCORDANCE AVEC NBR_REG
V14:	ld      sp,REGS+140
	jp      DECOMP0
;
D0_CHR:
;
;Place  en premier pour etre atteint par JR
;
	ex      af,af'
	ld      a,(hl)
	inc     hl
	exx
	ld      (de),a
	inc     e
	ex      af,af'
;
;On decremente nbr de caracteres restants.
;
	dec     a
	exx
	jp      p,D0_NEXT
;
;
	push    hl
	push    bc
	exx
;
	push    bc	; B DOIT ETRE NUL ICI
	push    hl	; Bidon
	push    de
	jp      (iy)
;
;
DECOMP0:
;;
;;Entree :	A  = nbr de donnees a decompacter - 1
;;		IY = adr de retour
;On suppose que longueur est code en negatif (ie -2 -> 2 caracteres)
;;
;;On recupere adr destination dans tous les cas
;;(Remarque : D ne change pas, il y a peut etre moyen d'optimiser cela)
;;
	pop     de
	pop     hl	;Adresse source pour copie chaine
;
;On recupere B = nbr de caracteres a copier   C est inutilise
;
	pop     bc
	inc     b
	dec     b
	jr      z,D0_FLAG
;
D0_MESUR:
;
;On regarde si longueur de chaine restante > nbr de donnees a fournir
;
	add     a,b
	jr      nc,D0_ALL
;
	ex      af,af'
D0_LP1:
	ld      a,(hl)
	inc     l
	ld      (de),a
	inc     e
	inc     b
	jr      nz,D0_LP1
	ex      af,af'
;
D0_FLAG:
;
;On recupere FLAGs et pointeur donnees compressees
;(B inutilise)
;
	exx
	pop     bc
	pop     hl
;
;
;On extrait nouveau flag
;
D0_NEXT:
	sla     c
	jr      nz,D0_FLGOK
;
	ld      c,(hl)
	inc     hl
	sll     c ; db #cb,#31
D0_FLGOK:
	jr      nc,D0_CHR
;
;Test similaire au precedent
;
	ld      b,(hl)
	inc     hl
	ld      d,a	; Sauve pour D0_LEFT
	add     a,b
	jr      nc,D0_LEFT
;
;Il restera (A+1) donnees a fournir apres copie de la chaine
;
	ex      af,af'
	ld      a,b
	exx
	ld      b,a
	exx
	ld      a,(hl)
	inc     hl
	exx
	ld      l,a
D0_LP2:
	ld      a,(hl)
	inc     l
	ld      (de),a
	inc     e
	inc     b
	jr      nz,D0_LP2
	ex      af,af'
	exx
	jr      D0_NEXT
;
D0_LEFT:
;
;Idem que D0_ALL mais sur moins de donnees.
;
	ex      af,af'	; Pour l'instant on conserve A-B
	ld      a,d	; Nombre de valeur restantes a copier-1
	exx
	ld      b,a
	inc     b
	exx
	ld      a,(hl)
	inc     hl
	push    hl
	push    bc
	exx
	ld      l,a
D0_LP3:
	ld      a,(hl)
	inc     l
	ld      (de),a
	inc     e
	djnz    D0_LP3
	ex      af,af'
	ld      b,a
	inc     b	; Longueur restante pour prochaine fois
	push    bc
;
	push    hl
	push    de
	jp      (iy)
;
;
D0_ALL:
;
;La chaine a copier fournit toutes les donnees
;
	inc     a
	ld      b,a	; Longueur restante pour prochaine fois
	push    bc
;
D0_COPY:
	ld      a,(hl)
	ld      (de),a
	inc     l
	inc     e
	ds      (NBRREG-1)*4	;Place pour NBR_REG copies (NBR_REG-1)*4
;;	ds      4	;Place pour D0_MODEL
;
D0_MODEL:		; Sera copie a la suite des LDI
	push    hl
	push    de
	jp      (iy)
D0_MODE_:
;
;
;
POKECODE:
;Code bon nombre de LDIs dans routines de decompression
;	ld      a,(NBR_REG)
;	dec     a
;	sla     a
;	sla     a
;	ld      c,a
;	ld      b,0
	ld      bc,(NBRREG-1)*4
	ld      hl,D0_COPY
	ld      de,D0_COPY+4
	ldir
;;	ld      hl,D0_MODEL
;;	ld      bc,D0_MODE_-D0_MODEL
;;	ldir
	ret
;
;
;
;Toutes les auto-modifs pour la gestion
RAZVAR:	ld      hl,VMESURE
	ld      (GETWITCH+1),hl
	xor     a
	ld      (PLAYPLAG+1),a
	call    SETVAR
	ret
;
;
;Init variables REGS pour la decompression.
SETVAR:	ld      b,NBRREG		; Nombre registres traites
	ld      a,DECRUBUF/#100
	ld      de,YMLZ	; Pointe sur donnees
	inc     de
	inc     de	; saute "longueur"
	ld      hl,REGS
RAZLOOP	push    bc
;On place adr DEST
	ld      (hl),0
	inc     hl
	ld      (hl),a
	inc     hl
;;
;; Adr source pour copie chaine : forcement meme poids fort qd fenetre #100
;;
	inc     hl
	ld      (hl),a
	inc     hl
	inc     a ; les buffers sont a la suite les uns de autres
;;
;; Valeur decalage (quand boucle, les donnees ne sont plus placees a partir de 0,
;les references absolues doivent etre corrigees)
;;
	ld      (hl),0
	inc     hl
;
;On place nbr de chr restant a copier = 0
;
	ld      (hl),0
	inc     hl
;
;Octet flag a #40 pour copie 1er octet et enclencher lecture nouveaux flags
;
	ld      (hl),#40
	inc     hl
	inc     hl
;
;Maintenant il faut lire adr debut donnees compresses,
;donnees en relatif par rapport a position courante dans header
;
	ex      de,hl
	inc     hl	; On saute type compression
	ld      c,(hl)
	inc     hl
	ld      b,(hl)
;
	push    hl
	add     hl,bc
	ld      b,h
	ld      c,l
	pop     hl
;
	inc     hl
	ex      de,hl
	ld      (hl),c
	inc     hl
	ld      (hl),b
	inc     hl
;
	pop     bc
	djnz    RAZLOOP
	ret
;
;
;
VAR			; Variables de travail
;
REGS	ds   NBRREG*10	;Variables pour chaque registre
;
;; Pour chaque registre, on a :
;;
;; Adresse destination     (DE)
;; Adresse source chaine   (HL)  ne sert pas forcement
;; Flag/compteur chaine    (BC)  C : poids faible decalage
;; Octet flags             (BC') B' inutilise
;; Source data compresses  (HL')
;

;DATA
;
;NBR_REG est une constante qui permet de determiner combien recuperer
;de donnees a la fois. Si NBR_REG = 14, on recupere 14 donnees par registre et
;par VBL. Au bout de 14 VBL, on peut jouer 14 fois tous les reg., le temps de
;recuperer 14*14 nouvelles donnees.
;
;NBR_REG	db      NBRREG	;!!! MODIFIER (V14-2) EN CONSEQUENCE !!
;
;
;ADRTEMP	dw      YMLZ


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Player subroutines

; Send2PSG (34 NOP + ret)
; In    ; A=value to send
;       ; C=PSG register
; Modif ; BC
Send2PSG ld b,#f4
	out (c),c
	ld bc,#f6c0
	out (c),c
;	ld bc,#f600
;	out (c),c
	out (c),0 ; db #ed,#71
	ld b,#f4
	out (c),a
	ld bc,#f680
	out (c),c
;	ld bc,#f600
;	out (c),c
	out (c),0 ; db #ed,#71
	ret

; Map Asic I/O register page (#4000-#7fff)
PageAsicOn
	ld bc,#7fb8
	out (c),c
	ret

; Unmap Asic I/O register page (#4000-#7fff)
PageAsicOff
	ld bc,#7fa0
	out (c),c
	ret

; Unlock ASIC of CPC+
DeLock_Asic
	di
	ld a,17
	ld hl,asic
DL_B1	ld b,#bd
	outi
	dec a
	jr nz,dl_b1
	ei
	ret

Asic	db 255,0,255,119,179,81,168,212,98,57,156,70,43,21,138,205,238

;###############################################################################

TabSmpAdr
	include"OUT.ASM"

;Align on even address
;for Maxam use 'org $+1 and #fffe' instead
 ifdef __VASM
   even ; or align 1 ; vasm
 else
   align 2 ; rasm, WinAPE...
 endif

SmpBase
	incbin "OUT.AYL",128 ; skip Amsdos header

SidList	dw #2fff,#0800,#1000,#0800,#1000,#4001,#4020
;                 rrnn    pp  rr00    pp
	dw #4020 ; double STOP instruction as race condition is possible (rewrite DCSR without SAR update)

YMLZ    incbin "OUT.AYC",128 ; skip Amsdos header
