;
;CPCTAY.SCE
;Base sur CPCT v1.09
;12/3/2000
;
;v2  20/4/2000 chez Shap : Gere fenetre de #400
;
;donnees sources en memoire centrale,
;donnees compresse stockee a l'ecran
; !!! On fait boucler sur #C000 -> pas de plantage mais donnees !!!
; !!! erronnees  (on suppose qu'un registre a peu de chance     !!!
; !!! de depasser 16 ko compresses)                             !!!
;
         ORG  #A300
         ENT  $
         JP   COMPRESS
         DEFS 3,0
         DEFS 3,0
;
COMPFILE EQU  #C000
;
YM       DEFW #800A                     ;Fichier source : doit etre place >#400
LONG     DEFW #2000                     ;Longueur source > 2
MAXLONG  DEFB 254                       ;Longueur-1 max de chaine souhaitee
DEST_ADR DEFW                           ;Adresse absolue de decompactage
LONGCOMP DEFW                           ;Longueur compactee
NBR_FLAG DEFW                           ;Nombre d'octet flags
NBR_BIT  DEFB                           ;nombre bit (octet flag incomplet)
;
;Donnees suivantes pas encore utilisees. Servira pour decompte temps machine
;
NBR_STR  DEFW                           ;Nombre de chaines
NBR_CHR  DEFW                           ;Nombre de caracteres
;
WIN100   DEFB 1                         ;1 : fenetre #100, 0 : #400
;
;
;
COMPRESS
         CALL RAZVAR
;
INIT
         LD   HL,(YM)                   ;Donnees @ lire
         LD   DE,COMPFILE
         CALL COPYCHR                   ;1er = forchement caractere
         INC  DE                        ;Laisse place pour flags (cf ADR_FLAG)
         LD   (OFCOMP),DE
;
         CALL TABLMOUV                  ;Fixe DE = adr fenetre (YM-#100)
;
;On fixe longueur parcourue a 1+1 :
;   - on a deja copie un caractere
;   - le +1 sert au test en fin de boucle
;
         LD   BC,2
LOOP
         PUSH BC
         PUSH DE
;
;On teste combien il reste de caracteres
;
         LD   B,H
         LD   C,L
         PUSH HL
         LD   HL,(YM_END)
         OR   A
         SBC  HL,BC                     ;S'il ne reste plus qu'un caractere
         JR   Z,C_NOTOK
;
         LD   A,(WIN100)
         OR   A
         JR   NZ,C_OK                   ;(ou 2 si fenetre #400) :
         DEC  HL                        ;pas de chaine a rechercher.
         LD   A,H
         OR   L
;
         JR   NZ,C_OK
;
C_NOTOK
         POP  HL
         POP  DE
         JP   CHR
;
C_OK
;
;on calcule DE=Position de depart pour la recherche
;           BC=Nbr de position de depart possible
;
         POP  HL
         CALL MIN
;
         CALL SEARCH
         POP  DE                        ;HL est intact
         LD   A,(MATCHFLG)
         OR   A                         ;Chaine trouvee ?
         JP   Z,CHR                     ; ...ben non
;
;Place parametres de chaine
;
         PUSH HL
;
;On rectifie poids faible si jamais donnees ne sont pas stockees
;a partir de #xx00
;
         LD   A,(WIN100)
         OR   A
         JR   NZ,STR100
;
         LD   HL,(POSITION)
         LD   BC,(YM)
         SBC  HL,BC                     ;!!! Carry !!!
         LD   A,H
         AND  3
         LD   B,A
         LD   C,L
         JR   STR_SUI
;
STR100
         LD   A,(YM)
         LD   C,A
         LD   A,(POSITION)
         SUB  C
         LD   C,A
;
STR_SUI
         LD   HL,(OFCOMP)
         LD   A,(MATCHMAX)
         INC  A
         NEG                            ;Pour optimisation decompacteur
         LD   (HL),A
         INC  HL
         SET  7,H
         SET  6,H
;
         LD   (HL),C
         INC  HL
         SET  7,H
         SET  6,H
         LD   A,(WIN100)
         OR   A
         JR   NZ,STR_SUI2
         LD   (HL),B
         INC  HL
         SET  7,H
         SET  6,H
;
STR_SUI2
         SCF                            ;Bit 1 : flag pour chaine
         CALL PUT_FLAG
         LD   (OFCOMP),HL
;
;On fait avancer pointeur fichier source et pointeur fenetre
;
         POP  HL
         LD   A,(MATCHMAX)
         LD   B,0
         LD   C,A
         DEC  C                         ;Traitement 0 = #100
         INC  BC
         INC  BC                        ;longueur reelle = 1 + MATCHMAX
         ADD  HL,BC                     ;Pointeur se retrouve <longueur de
         EX   DE,HL                     ;chaine> plus loin
         ADD  HL,BC                     ;Table mouvante suit
         EX   DE,HL
         EX   (SP),HL                   ;Sauve HL, recupere Longueur fichier
         ADD  HL,BC
         EX   (SP),HL                   ;Ni vu ni connu
;
         JP   SUITE
;
;
CHR
         LD   A,(HL)                    ;Caractere en cours
         INC  HL
         INC  DE                        ;Table mouvante suit
         POP  BC
         INC  BC                        ;Longueur compressee
         PUSH BC
         PUSH HL
;
         LD   HL,(OFCOMP)               ;Fichier compresse
         LD   (HL),A
         INC  HL
         SET  7,H
         SET  6,H
;
;
         OR   A                         ;Bit 0 = Flag chr
         CALL PUT_FLAG
         LD   (OFCOMP),HL
         POP  HL
;
SUITE
;
         POP  BC
;
;Est-ce que BC a depasse long ?
;(BC = longueur traitee + 1)
;
         PUSH HL
         LD   HL,(LONG)
         OR   A
         SBC  HL,BC
         POP  HL
         JP   NC,LOOP
;
;
LAST
;
; Ultimes traitements
;
;
; Si CBITFLAG=8, WRITEFLG a reserve un octet pour flag qui est maintenant
; superflu. Ca permet en plus de bien replacer OFCOMP pour correction longueur
; chaine (voir plus bas)
;
         PUSH BC
         LD   A,(CBITFLAG)
         CP   8
         CALL Z,CORR_OF
         POP  BC
;
; On verifie qu'on a pas deborde (cas derniere chaine trop longue)
;
         LD   HL,(LONG)
         INC  HL
         OR   A
         SBC  HL,BC
         JR   Z,LONG_OK
;
         LD   C,L                       ;longueur en trop (signee)
         LD   HL,(OFCOMP)
         CALL DECHL
         CALL DECHL
         LD   A,(HL)
         SUB  C                         ;Correction
         LD   (HL),A
;
LONG_OK
;
;Ils faut caler flags "a gauche de l'octet"
;
         LD   A,(CBITFLAG)              ;Dernier octet non complet ?
         CP   8
         JR   Z,NBIT_OK
         LD   B,A
         LD   A,(BITFLAG)
BIT_NOOK SLA  A                         ;On place les bits bien @ gauche
         DJNZ BIT_NOOK
         LD   HL,(ADR_FLAG)
         LD   (HL),A
;
NBIT_OK
         LD   A,(CBITFLAG)
         SUB  8
         NEG
         LD   (NBR_BIT),A
;
;on calcule longueur fichier compacte
;ATTENTION CAS >16K N'EST PAS DETECTE
;
         LD   HL,(OFCOMP)
         LD   DE,-COMPFILE
         ADD  HL,DE
         LD   (LONGCOMP),HL
;
;
FIN
         RET
;
;
CORR_OF
;
;Il faut corriger : WRITEFLG avait laisser un autre espace pour flags.
;
         LD   B,#7F
         LD   A,(BANK)
         LD   HL,(OFCOMP)
         CALL DECHL
         LD   (OFCOMP),HL
         LD   (BANK),A
         RET
;
;
;
SEARCH                                  ;Cherche la plus longue chaine
         XOR  A
         LD   (MATCHFLG),A
         LD   (MATCHMAX),A
S_STR    XOR  A
         LD   (MATCHLON),A              ;Nettoie longueur trouvee
;
;Il faut trouver au moins une chaine de 2 caracteres (3 sans fenetre)
;
         LD   A,(DE)
         CP   (HL)
         JR   NZ,S_NOTOK0
         PUSH HL
         PUSH DE
         INC  HL
         INC  DE
         LD   A,(DE)
         CP   (HL)
         JR   NZ,S_NOTOK1               ;Idem que NOTOK0, mais avec POP !
;
         LD   A,(WIN100)
         OR   A
         LD   A,1
         JR   NZ,OKWITH2
;
         INC  DE
         INC  HL
         LD   A,(DE)
         CP   (HL)
         JR   NZ,S_NOTOK1
         LD   A,2
;
OKWITH2
         LD   (MATCHFLG),A
         LD   (MATCHLON),A
;
S_CHR
         INC  DE
         INC  HL
         LD   A,(DE)
         CP   (HL)
         JR   Z,S_NXTCHR                ;Compare les prochains caracteres
;
         LD   A,(MATCHMAX)              ;Nouvelle chaine plus grande ?
         LD   L,A                       ;Si meme longueur, on prend qd meme :
         LD   A,(MATCHLON)              ;elle sera placee plus loin
         CP   L
         POP  DE
         JR   C,S_NXTSTR                ;Cherche a partir d'une nouvelle pos
;
         LD   (MATCHMAX),A              ;la nouvelle ch trouvee est + grande
         LD   (POSITION),DE
S_NXTSTR
         POP  HL                        ;Pointeur remis au debut pour comparais
S_NOTOK0
         INC  DE                        ;On essaie un charactere apres
         DEC  BC                        ;Mais peut-etre a-t-on atteint
         LD   A,B                       ;tout les caracteres lus ?
         OR   C
         RET  Z                         ;SI OUI : FINI
         JR   S_STR
;
S_NOTOK1
         POP  DE
         POP  HL
         INC  DE
         DEC  BC
         LD   A,B
         OR   C
         RET  Z
         JR   S_STR
;
;
S_NXTCHR                                ;Tant que c identique, ca roule
         LD   A,(MATCHLON)
         INC  A
         LD   (MATCHLON),A
S_MAXLON CP   0
         JR   NZ,S_CHR
         LD   (MATCHMAX),A
         POP  HL                        ;On court circuite car la longueur
         LD   (POSITION),HL             ;max (0=256) est atteinte
         POP  HL
         RET                            ;FINI AUSSI
;
;
TABLMOUV                                ;Fixe adresse de depart Table mouvante
;
         LD   DE,(YM)
         INC  DE
         DEC  D
         LD   A,(WIN100)
         OR   A
         RET  NZ
;
         DEC  D
         DEC  D
         DEC  D
         RET
;
;
MIN
;
;             BC = min(WINSIZE, nbr de data deja lu)
;             DE = max(Position - WINSIZE, Debut donnee (YM))
;
MIN_JP   JP   MIN_DEB
MIN_DEB
         PUSH HL
         LD   HL,(YM)
         OR   A
         SBC  HL,DE
         JR   C,M_ALLWIN                ;DE est plus grand : BC = WINSIZE
         LD   D,H                       ;Difference entre YM et DE = n
         LD   E,L                       ;Il y a WINSIZE - n chr deja lus
         LD   H,1
         LD   A,(WIN100)
         OR   A
         JR   NZ,MIN_OK1
         LD   H,4
MIN_OK1
         LD   L,0
         SBC  HL,DE
         LD   B,H
         LD   C,L
         LD   DE,(YM)                   ;MAX (DE, YM)
         POP  HL
         RET
;
M_ALLWIN
;
;Des que DE depasse YM, ce n'est plus la peine de tester
;
         POP  HL
         LD   BC,MIN_SUI1
         LD   A,(WIN100)
         OR   A
         JR   NZ,MIN_SUIX
         LD   BC,MIN_SUI4
MIN_SUIX
         LD   (MIN_JP+1),BC
         PUSH BC
         RET
;
MIN_SUI1
         LD   BC,#100
         RET
MIN_SUI4
         LD   BC,#400
         RET
;
         ELSE
;
;Sans fenetre : BC = Nbr de caracteres deja lus
;               DE reste position de depart (YM)
;
         PUSH HL
         OR   A
         SBC  HL,DE
         LD   B,H
         LD   C,L
         POP  HL
         RET
         END
;
;
PUT_FLAG
;
;insert flag
;
         LD   A,(CBITFLAG)
         LD   B,A
         LD   A,(BITFLAG)
         RLA
         LD   (BITFLAG),A
         DJNZ BIT_OK                    ;C'est pas une boucle
;
         PUSH HL
         LD   HL,(NBR_FLAG)
         INC  HL
         LD   (NBR_FLAG),HL
         LD   HL,(ADR_FLAG)             ;On avait laisse un octet libre
         LD   (HL),A
         POP  HL
         LD   (ADR_FLAG),HL             ;Nouvelle adresse octet libre
         INC  HL
         SET  7,H
         SET  6,H
;
         LD   B,8
BIT_OK
         LD   A,B
         LD   (CBITFLAG),A
         RET
;
DECHL
;
         DEC  HL
         SET  7,H
         SET  6,H
         RET
;
;
COPYCHR
;
;Copie caractere en tenant compte des banks
;
         LD   A,(HL)
         INC  HL
         LD   (DE),A
         INC  DE
         RET
;
;
;
RAZVAR   LD   HL,DEFAUT
         LD   DE,VARIABLE
         LD   BC,DEFAUT-VARIABLE
         LDIR
;
         LD   HL,MIN_DEB
         LD   (MIN_JP+1),HL
;
         LD   A,(MAXLONG)
         LD   (S_MAXLON+1),A
;
         LD   HL,0
         LD   (NBR_FLAG),HL
         LD   (NBR_STR),HL
         LD   (NBR_CHR),HL
;
         LD   HL,(YM)
         LD   DE,(LONG)
;
;Pour detection derniers caracteres
;
         ADD  HL,DE
         DEC  HL
         LD   (YM_END),HL
;
         RET
;
VARIABLE
BANK     DEFB                           ;BANK courante
CBITFLAG DEFB                           ;Compteur de bit FLAG (8 a 1)
BANKFLAG DEFB                           ;BANK pour stockage octet flag
ADR_FLAG DEFW                           ;Adr pour flag
BITFLAG  DEFB                           ;Flags en question
MATCHFLG DEFB                           ;Chaine plus grande que 1 ?
MATCHLON DEFB                           ;Longueur de chaine trouvee
MATCHMAX DEFB                           ;Long max trouvee (0=2, 1=3, ...)
POSITION DEFW                           ;Position absolue de chaine
OFCOMP   DEFW                           ;Pointeur fichier compacte
YM_END   DEFW                           ;Fin fichier source
;
DEFAUT
         DEFB #C4
         DEFB 8
         DEFB #C4
         DEFW COMPFILE+1
